/*****************************************************************************
 * $Source: /cvsroot/charm-6.1.3/src/ck-ldb/RefineCommLB.C,v $
 * $Author: gzheng $
 * $Date: 2005-01-10 04:20:39 $
 * $Revision: 1.4 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

#include <charm++.h>

#include "cklists.h"

#include "RefineCommLB.h"

CreateLBFunc_Def(RefineCommLB, "Average load among processors by moving objects away from overloaded processor, communication aware");

RefineCommLB::RefineCommLB(const CkLBOptions &opt): RefineLB(opt)
{
  lbname = (char *)"RefineCommLB";
  if (CkMyPe() == 0)
    CkPrintf("[%d] RefineCommLB created\n",CkMyPe());
}

CmiBool RefineCommLB::QueryBalanceNow(int _step)
{
  return CmiTrue;
}

void RefineCommLB::work(BaseLB::LDStats* stats, int count)
{
#if CMK_LBDB_ON
  int obj;
  //  CkPrintf("[%d] RefineLB strategy\n",CkMyPe());

  // RemoveNonMigratable(stats, count);

  // get original object mapping
  int* from_procs = RefinerComm::AllocProcs(count, stats);
  for(obj=0;obj<stats->n_objs;obj++)  {
    int pe = stats->from_proc[obj];
    from_procs[obj] = pe;
  }

  // Get a new buffer to refine into
  int* to_procs = RefinerComm::AllocProcs(count,stats);

  RefinerComm refiner(1.003);  // overload tolerance=1.05

  refiner.Refine(count,stats,from_procs,to_procs);

  // Save output
  for(obj=0;obj<stats->n_objs;obj++) {
      int pe = stats->from_proc[obj];
      if (to_procs[obj] != pe) {
	// CkPrintf("[%d] Obj %d migrating from %d to %d\n",
	//	 CkMyPe(),obj,pe,to_procs[obj]);
	stats->to_proc[obj] = to_procs[obj];
      }
  }

  // Free the refine buffers
  RefinerComm::FreeProcs(from_procs);
  RefinerComm::FreeProcs(to_procs);
#endif
};

#include "RefineCommLB.def.h"

/*@}*/
