/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.pdata.ChareInfo;
import charm.debug.pdata.EpInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PythonInstalledCode
extends JDialog {
    Vector installed = new Vector();
    JTable table;
    PythonTableModel tableModel;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final String[] colNames = new String[]{"Entry Point", "Where", "Associated Chare", "Code"};

    public PythonInstalledCode(boolean modal) {
        super((Frame)null, "Python script", modal);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setMinimumSize(new Dimension(400, 300));
        this.tableModel = new PythonTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getColumnModel().getColumn(3).setCellRenderer(new PythonCodeRenderer());
        JScrollPane tableScroll = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add(tableScroll);
    }

    public void add(String code, Vector[] eps, ChareInfo chare) {
        int i;
        int firstRow = this.tableModel.getRowCount();
        for (i = 0; i < eps[0].size(); ++i) {
            this.installed.add(new InstalledCode(code, (EpInfo)eps[0].elementAt(i), chare, 0));
        }
        for (i = 0; i < eps[1].size(); ++i) {
            this.installed.add(new InstalledCode(code, (EpInfo)eps[1].elementAt(i), chare, 1));
        }
        int lastRow = this.tableModel.getRowCount() - 1;
        this.tableModel.fireTableRowsInserted(firstRow, lastRow);
    }

    static class PythonCodeRenderer
    extends DefaultTableCellRenderer {
        PythonCodeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component ret = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int height = ret.getPreferredSize().height;
            if (table.getRowHeight(row) != height) {
                table.setRowHeight(row, height);
            }
            return ret;
        }
    }

    class PythonTableModel
    extends AbstractTableModel {
        PythonTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return PythonInstalledCode.this.installed.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            InstalledCode line = (InstalledCode)PythonInstalledCode.this.installed.elementAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return line.ep;
                }
                case 1: {
                    return (line.where == 0 ? "BEFORE" : "") + (line.where == 1 ? "AFTER" : "");
                }
                case 2: {
                    return line.chare;
                }
                case 3: {
                    return "<html><pre>" + line.code + "</pre></html>";
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int index) {
            return colNames[index];
        }
    }

    class InstalledCode {
        String code;
        EpInfo ep;
        ChareInfo chare;
        int where;

        InstalledCode(String s, EpInfo e, ChareInfo c, int w) {
            this.code = s;
            this.ep = e;
            this.chare = c;
            this.where = w;
        }
    }
}

