/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import javax.swing.JTextField;

public class JFloatTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private String lastValue;
    int lastCaretPosition;

    public JFloatTextField(float defval, int size) {
        super("" + defval, size);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                if (!('0' <= ch && ch <= '9' || ch == '.' || Character.isISOControl(ch))) {
                    evt.consume();
                } else {
                    JFloatTextField.this.lastCaretPosition = JFloatTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + defval;
    }

    private void checkValue() {
        try {
            Float.valueOf(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException e) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public boolean isValueValid() {
        try {
            Float.valueOf(this.getText().trim() + "0");
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public float getValue() {
        this.checkValue();
        try {
            return Float.valueOf(this.getText().trim()).floatValue();
        }
        catch (NumberFormatException e) {
            return Float.valueOf(this.lastValue).floatValue();
        }
    }

    public void textValueChanged(TextEvent evt) {
        this.checkValue();
    }
}

