/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import projections.gui.GraphData;
import projections.gui.GraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedGraphDataList;
import projections.gui.ZItem;

public class GraphDisplayCanvas
extends Canvas {
    int myRun = 0;
    private GraphData data;
    private OrderedGraphDataList graphDataList;
    private Image offscreen;

    public GraphDisplayCanvas() {
        this.setBackground(MainWindow.runObject[this.myRun].background);
    }

    private void addDataForBar(ZItem item, int x) {
        int h = this.getSize().height;
        int y = 0;
        y = this.data.xmode == 0 ? item.curPData[x] : item.curIData[x];
        if (MainWindow.dataDump != null && GraphWindow.dumpNow) {
            MainWindow.dataDump.print(" " + y);
        }
        y = item.ymode == 12 ? h - (int)(this.data.wscale * (double)y) : h - (int)(this.data.yscale * (double)y);
        this.graphDataList.insert(y, item.color);
    }

    private void drawDisplay(Graphics g) {
        if (this.data == null) {
            return;
        }
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(MainWindow.runObject[this.myRun].background);
        g.fillRect(0, 0, w, h);
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        g.translate(-this.data.displayPanel.getHSBValue(), 0);
        if (MainWindow.dataDump != null && GraphWindow.dumpNow) {
            if (this.data.xmode == 0) {
                MainWindow.dataDump.println("--- Graph PE ---");
            } else {
                MainWindow.dataDump.println("--- Graph INT ---");
            }
        }
        if (this.data.graphtype == 20) {
            for (int a = 0; a < this.data.onGraph.length; ++a) {
                if (this.data.ymode == 11) {
                    if (this.data.onGraph[a].ymode == 10) continue;
                    this.drawItemLine(g, this.data.onGraph[a]);
                    continue;
                }
                if (this.data.onGraph[a].ymode == 11) continue;
                this.drawItemLine(g, this.data.onGraph[a]);
            }
        } else {
            this.graphDataList = new OrderedGraphDataList();
            long x_value = 0L;
            if (this.data.xmode == 0) {
                this.data.origProcList.reset();
                x_value = this.data.origProcList.nextElement();
            } else {
                this.data.interval.list.reset();
                x_value = (long)this.data.interval.list.nextElement() * this.data.interval.size;
            }
            for (int x = this.data.minx; x <= this.data.maxx; ++x) {
                this.graphDataList.removeAll();
                if (MainWindow.dataDump != null) {
                    MainWindow.dataDump.print(x_value);
                    x_value = this.data.xmode == 0 ? (long)this.data.origProcList.nextElement() : (long)this.data.interval.list.nextElement() * this.data.interval.size;
                }
                for (int a = 0; a < this.data.onGraph.length; ++a) {
                    if (this.data.ymode == 11) {
                        if (this.data.onGraph[a].ymode == 10) continue;
                        this.addDataForBar(this.data.onGraph[a], x);
                        continue;
                    }
                    if (this.data.onGraph[a].ymode == 11) continue;
                    this.addDataForBar(this.data.onGraph[a], x);
                }
                if (MainWindow.dataDump != null) {
                    MainWindow.dataDump.println();
                }
                this.drawItemBar(g, x);
            }
        }
        if (MainWindow.dataDump != null && GraphWindow.dumpNow) {
            MainWindow.dataDump.flush();
            GraphWindow.dumpNow = false;
        }
    }

    private void drawItemBar(Graphics g, int x) {
        int x1 = (int)(this.data.xscale * (double)x);
        int w = (int)(this.data.xscale * (double)(x + 1)) - x1 - 1;
        if (w < 1) {
            w = 1;
        }
        x1 += this.data.offset3;
        this.graphDataList.reset();
        while (this.graphDataList.hasMoreElements()) {
            int y = this.graphDataList.currentY();
            Color c = this.graphDataList.currentC();
            int h = this.getSize().height - y;
            if (h > 0) {
                g.setColor(c);
                g.fillRect(x1, y, w, h);
            }
            this.graphDataList.nextElement();
        }
    }

    private void drawItemLine(Graphics g, ZItem item) {
        g.setColor(item.color);
        int y1 = -1;
        int x1 = -1;
        int h = this.getSize().height;
        for (int x = this.data.minx; x <= this.data.maxx; ++x) {
            int x2 = this.data.offset3 + (int)((double)x * this.data.xscale);
            int y2 = this.data.xmode == 0 ? item.curPData[x] : item.curIData[x];
            if (MainWindow.dataDump != null) {
                MainWindow.dataDump.print(" " + y2);
            }
            y2 = item.ymode == 12 ? h - (int)(this.data.wscale * (double)y2) : h - (int)(this.data.yscale * (double)y2);
            if (x1 >= 0 && (y2 != h || y1 != y2)) {
                g.drawLine(x1, y1, x2, y2);
            }
            x1 = x2;
            y1 = y2;
        }
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            return;
        }
        Graphics og = this.offscreen.getGraphics();
        this.drawDisplay(og);
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.drawImage(this.offscreen, 0, 0, w, h, 0, 0, w, h, null);
    }

    public void print(Graphics pg) {
        ((Graphics2D)pg).setBackground(Color.white);
        this.setForeground(Color.black);
        this.drawDisplay(pg);
        ((Graphics2D)pg).setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.getSize().width != w || this.getSize().height != h) {
            try {
                this.offscreen = this.createImage(w, h);
            }
            catch (OutOfMemoryError e) {
                System.out.println("NOT ENOUGH MEMORY!");
            }
        }
        super.setBounds(x, y, w, h);
    }

    public void setData(GraphData data) {
        this.data = data;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

