/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import projections.analysis.IntervalCapableReader;
import projections.analysis.IntervalUtils;
import projections.analysis.ParseTokenizer;
import projections.analysis.ProjectionsFormatException;
import projections.analysis.ProjectionsReader;

public class AccumulatedSummaryReader
extends ProjectionsReader
implements IntervalCapableReader {
    public int numProcessors;
    public long numIntervals;
    public double intervalSize;
    public double totalTime;
    private double[] utilization;

    public AccumulatedSummaryReader(String filename, String version) {
        super(filename, version);
    }

    protected boolean checkAvailable() {
        File sourceFile = new File(this.sourceString);
        return sourceFile.canRead();
    }

    protected void readStaticData() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.sourceString));
        ParseTokenizer tokenizer = this.initNewTokenizer(reader);
        try {
            tokenizer.checkNextString("ver");
            double tempVersionNum = tokenizer.nextNumber("Version");
            if (tempVersionNum != Double.parseDouble(this.expectedVersion)) {
                throw new ProjectionsFormatException(this.expectedVersion, "Expected version does not match one read on file!");
            }
            tokenizer.checkNextString("pes");
            this.numProcessors = (int)tokenizer.nextNumber("Total Number of Processors");
            tokenizer.checkNextString("count");
            this.numIntervals = (long)tokenizer.nextNumber("Number of Intervals");
            tokenizer.checkNextString("interval");
            this.intervalSize = tokenizer.nextScientific("Interval Size") * 1000000.0;
            this.totalTime = (double)this.numIntervals * this.intervalSize;
            if (!tokenizer.isEOL()) {
                throw new ProjectionsFormatException(this.expectedVersion, "Extra Stuff at the end of header line.");
            }
        }
        catch (IOException e) {
            throw new ProjectionsFormatException(this.expectedVersion, e.toString());
        }
        reader.close();
    }

    public void reset() {
    }

    private ParseTokenizer initNewTokenizer(Reader reader) {
        ParseTokenizer tokenizer = new ParseTokenizer(reader);
        tokenizer.parseNumbers();
        tokenizer.eolIsSignificant(true);
        tokenizer.whitespaceChars(47, 47);
        tokenizer.whitespaceChars(58, 58);
        tokenizer.whitespaceChars(91, 91);
        tokenizer.whitespaceChars(93, 93);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        return tokenizer;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    public void loadIntervalData(long startInterval, long endInterval) throws IOException {
        this.loadIntervalData(this.intervalSize, startInterval, endInterval);
    }

    public void loadIntervalData(double intervalSize, long startInterval, long endInterval) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.sourceString));
        ParseTokenizer tokenizer = this.initNewTokenizer(reader);
        int numIntervals = (int)(endInterval - startInterval + 1L);
        this.utilization = new double[numIntervals];
        tokenizer.skipLine();
        double originalIntervalSize = this.intervalSize;
        double newStartTime = intervalSize * (double)startInterval;
        double newEndTime = (double)endInterval * intervalSize;
        long interval = 0L;
        while (!tokenizer.isEOL()) {
            if ((double)(interval + 1L) * originalIntervalSize < newStartTime) {
                ++interval;
                continue;
            }
            double valueRead = tokenizer.nval;
            IntervalUtils.fillIntervals(this.utilization, (long)intervalSize, startInterval, (long)((double)interval * originalIntervalSize), (long)((double)(interval + 1L) * originalIntervalSize), originalIntervalSize * (valueRead / 100.0), false);
            if (!((double)(++interval) * originalIntervalSize > newEndTime)) continue;
            break;
        }
        if (tokenizer.isEOL()) {
            throw new ProjectionsFormatException(this.expectedVersion, "Unexpected EOL when reading utilization data!");
        }
        reader.close();
        IntervalUtils.timeToUtil(this.utilization, intervalSize);
    }

    public double[] getUtilData() {
        return this.utilization;
    }

    public static void main(String[] args) {
        String filename = args[0];
        AccumulatedSummaryReader reader = new AccumulatedSummaryReader(filename, "5.0");
        System.out.println(reader.getIntervalSize());
        System.out.println(reader.numProcessors);
        System.out.println(reader.numIntervals);
        System.out.println(reader.intervalSize);
        System.out.println(reader.totalTime);
        try {
            reader.loadIntervalData(0L, reader.numIntervals - 1L);
            double[] data = reader.getUtilData();
            for (int i = 0; i < data.length; ++i) {
                System.out.print((long)data[i] + " ");
            }
            System.out.println();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }
}

