/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericElement;
import charm.debug.inspect.TypedefType;

public class InspectedElement {
    GenericElement e;
    GenericElement original;
    String value;

    public InspectedElement(GenericElement el, String v) {
        this.e = el;
        this.original = el;
        this.value = v;
    }

    public boolean isPointer() {
        return this.e.getPointer() + this.e.getType().getPointer() > 0;
    }

    public String toString() {
        String t = this.e.getType().getName();
        String n = this.e.getName();
        int p = this.e.getPointer();
        StringBuffer result = new StringBuffer();
        if (!this.e.equals(this.original)) {
            result.append("=>");
        }
        if (t != null) {
            result.append(t);
        }
        for (int i = 0; i < p; ++i) {
            result.append('*');
        }
        if (this.e.getType() instanceof TypedefType) {
            int i;
            TypedefType tdt = (TypedefType)this.e.getType();
            result.append(" (").append(tdt.getType().getName());
            for (i = 0; i < p; ++i) {
                result.append('*');
            }
            for (i = 0; i < tdt.getPointer(); ++i) {
                result.append('*');
            }
            result.append(")");
        }
        if (n != null) {
            result.append(' ').append(n);
        }
        result.append(" = ");
        if (this.value != null) {
            result.append(this.value);
        }
        return result.toString();
    }
}

