/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MemoryDialog
extends JDialog
implements ActionListener,
DocumentListener {
    JComboBox peList;
    JTextField scanSize;
    JTextField lines;
    JLabel vPixels;
    JTextField hPixels;
    JButton ok;
    JButton cancel;
    boolean confirmed = false;

    MemoryDialog(Frame parent, boolean modal, int nprocs) {
        super(parent, "Memory", modal);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel topPane = new JPanel();
        topPane.setLayout(new GridLayout(5, 2));
        JLabel textPeList = new JLabel("Processor number: ");
        topPane.add(textPeList);
        String[] pes = new String[nprocs];
        for (int i = 0; i < nprocs; ++i) {
            pes[i] = new Integer(i).toString();
        }
        this.peList = new JComboBox<String>(pes);
        this.peList.setSelectedIndex(0);
        topPane.add(this.peList);
        JLabel textScanSize = new JLabel("Line width: ");
        topPane.add(textScanSize);
        this.scanSize = new JTextField("16");
        this.scanSize.addActionListener(this);
        this.scanSize.getDocument().addDocumentListener(this);
        topPane.add(this.scanSize);
        JLabel textLines = new JLabel("Number of lines: ");
        topPane.add(textLines);
        this.lines = new JTextField("50");
        this.lines.addActionListener(this);
        this.lines.getDocument().addDocumentListener(this);
        topPane.add(this.lines);
        JLabel textVPixels = new JLabel("Veritcal pixels: ");
        topPane.add(textVPixels);
        int pixels = Integer.parseInt(this.scanSize.getText()) * Integer.parseInt(this.lines.getText());
        this.vPixels = new JLabel("" + pixels);
        topPane.add(this.vPixels);
        JLabel textHPixels = new JLabel("Horizontal pixels: ");
        topPane.add(textHPixels);
        this.hPixels = new JTextField("1000");
        this.hPixels.addActionListener(this);
        topPane.add(this.hPixels);
        JPanel bottomPane = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        bottomPane.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        bottomPane.add(this.cancel);
        this.getContentPane().add(topPane);
        this.getContentPane().add(bottomPane);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public int getPe() {
        return this.peList.getSelectedIndex();
    }

    public int getScan() {
        return Integer.parseInt(this.scanSize.getText());
    }

    public int getLines() {
        return Integer.parseInt(this.lines.getText());
    }

    public int getHPixels() {
        return Integer.parseInt(this.hPixels.getText());
    }

    public boolean confirmed() {
        return this.confirmed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok") || e.getSource() == this.scanSize || e.getSource() == this.lines || e.getSource() == this.hPixels) {
            try {
                if (this.peList.getSelectedIndex() >= 0 && Integer.parseInt(this.scanSize.getText()) > 3 && Integer.parseInt(this.lines.getText()) > 0 && Integer.parseInt(this.hPixels.getText()) > 10) {
                    this.confirmed = true;
                    this.setVisible(false);
                } else if (Integer.parseInt(this.scanSize.getText()) <= 3) {
                    JOptionPane.showMessageDialog(this, "The width of the line must be greater than 3", "Error", 0);
                    this.scanSize.requestFocus();
                } else if (Integer.parseInt(this.lines.getText()) <= 0) {
                    JOptionPane.showMessageDialog(this, "The number of lines must be positive", "Error", 0);
                    this.lines.requestFocus();
                } else if (Integer.parseInt(this.hPixels.getText()) <= 10) {
                    JOptionPane.showMessageDialog(this, "The number of horizontal pixels must be greater than 10", "Error", 0);
                    this.hPixels.requestFocus();
                }
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
            }
        }
        if (e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updatePixels();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updatePixels();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void updatePixels() {
        try {
            int ss = Integer.parseInt(this.scanSize.getText());
            int l = Integer.parseInt(this.lines.getText());
            if (ss > 0 && l > 0) {
                int vp = ss * l;
                this.vPixels.setText("" + vp);
            }
        }
        catch (NumberFormatException ne) {
            this.vPixels.setText("??");
        }
    }
}

