/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import projections.analysis.ProjMain;
import projections.gui.AmpiProfileWindow;
import projections.gui.AnimationWindow;
import projections.gui.CallTableWindow;
import projections.gui.CommTimeWindow;
import projections.gui.CommWindow;
import projections.gui.FunctionTool;
import projections.gui.GraphWindow;
import projections.gui.HistogramWindow;
import projections.gui.LogFileViewer.LogFileViewerWindow;
import projections.gui.MainWindow;
import projections.gui.MultiRunWindow;
import projections.gui.NoiseMinerWindow;
import projections.gui.OutlierAnalysisWindow;
import projections.gui.ProfileWindow;
import projections.gui.StlWindow;
import projections.gui.TimeProfileWindow;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.UserEventsWindow;

public class MainMenuManager
implements ActionListener,
ItemListener {
    private JMenuBar menubar;
    private JMenu fileMenu;
    private JMenu preferencesMenu;
    private JMenu toolMenu;
    private JMenuItem graphMenuItem;
    private static final int NO_DATA = 0;
    private static final int OPENED_FILES = 1;
    private static final int OPENED_SUMMARY = 2;
    private MainWindow parent;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileCloseMenuItem;
    private JMenuItem fileCloseAllMenuItem;
    private JMenuItem fileQuitMenuItem;
    private JMenuItem changeBGColorMenuItem;
    private JMenuItem changeFGColorMenuItem;
    private JMenuItem useGrayscaleColorsMenuItem;
    private JMenuItem useStandardColorsMenuItem;
    private JMenuItem timelinesMenuItem;
    private JMenuItem usageProfileMenuItem;
    private JMenuItem communicationMenuItem;
    private JMenuItem communicationVsTimeMenuItem;
    private JMenuItem callTableMenuItem;
    private JMenuItem viewLogFilesMenuItem;
    private JMenuItem histogramsMenuItem;
    private JMenuItem overviewMenuItem;
    private JMenuItem userEventsMenuItem;
    private JMenuItem outlierAnalysisMenuItem;
    private JMenuItem animationMenuItem;
    private JMenuItem timeProfileGraphMenuItem;
    private JMenuItem multirunAnalysisMenuItem;
    private JMenuItem functionToolMenuItem;
    private JMenuItem AMPIUsageProfileMenuItem;
    private JMenuItem noiseMinerMenuItem;

    public MainMenuManager(JFrame parent) {
        this.parent = (MainWindow)parent;
        this.createMenus();
    }

    void stateChanged(int state) {
        switch (state) {
            case 0: {
                this.fileOpenMenuItem.setEnabled(true);
                this.fileCloseMenuItem.setEnabled(false);
                this.fileCloseAllMenuItem.setEnabled(false);
                this.fileQuitMenuItem.setEnabled(true);
                this.changeBGColorMenuItem.setEnabled(true);
                this.changeFGColorMenuItem.setEnabled(false);
                this.useGrayscaleColorsMenuItem.setEnabled(false);
                this.useStandardColorsMenuItem.setEnabled(false);
                this.graphMenuItem.setEnabled(false);
                this.timelinesMenuItem.setEnabled(false);
                this.usageProfileMenuItem.setEnabled(false);
                this.communicationMenuItem.setEnabled(false);
                this.communicationVsTimeMenuItem.setEnabled(false);
                this.callTableMenuItem.setEnabled(false);
                this.viewLogFilesMenuItem.setEnabled(false);
                this.histogramsMenuItem.setEnabled(false);
                this.overviewMenuItem.setEnabled(false);
                this.animationMenuItem.setEnabled(false);
                this.timeProfileGraphMenuItem.setEnabled(false);
                this.userEventsMenuItem.setEnabled(false);
                this.outlierAnalysisMenuItem.setEnabled(false);
                this.multirunAnalysisMenuItem.setEnabled(true);
                this.functionToolMenuItem.setEnabled(false);
                this.AMPIUsageProfileMenuItem.setEnabled(false);
                this.noiseMinerMenuItem.setEnabled(false);
                break;
            }
            case 2: {
                this.fileOpenMenuItem.setEnabled(true);
                this.fileCloseMenuItem.setEnabled(true);
                this.fileCloseAllMenuItem.setEnabled(true);
                this.fileQuitMenuItem.setEnabled(true);
                this.changeBGColorMenuItem.setEnabled(true);
                this.changeFGColorMenuItem.setEnabled(true);
                this.useGrayscaleColorsMenuItem.setEnabled(false);
                this.useStandardColorsMenuItem.setEnabled(false);
                this.graphMenuItem.setEnabled(true);
                this.timelinesMenuItem.setEnabled(false);
                this.usageProfileMenuItem.setEnabled(true);
                this.communicationMenuItem.setEnabled(false);
                this.communicationVsTimeMenuItem.setEnabled(false);
                this.callTableMenuItem.setEnabled(false);
                this.viewLogFilesMenuItem.setEnabled(false);
                this.histogramsMenuItem.setEnabled(false);
                this.overviewMenuItem.setEnabled(true);
                this.animationMenuItem.setEnabled(true);
                this.timeProfileGraphMenuItem.setEnabled(false);
                this.userEventsMenuItem.setEnabled(false);
                this.outlierAnalysisMenuItem.setEnabled(false);
                this.multirunAnalysisMenuItem.setEnabled(true);
                this.functionToolMenuItem.setEnabled(false);
                this.AMPIUsageProfileMenuItem.setEnabled(true);
                this.noiseMinerMenuItem.setEnabled(true);
                break;
            }
            case 1: {
                this.fileOpenMenuItem.setEnabled(true);
                this.fileCloseMenuItem.setEnabled(true);
                this.fileCloseAllMenuItem.setEnabled(true);
                this.fileQuitMenuItem.setEnabled(true);
                this.changeBGColorMenuItem.setEnabled(true);
                this.changeFGColorMenuItem.setEnabled(true);
                this.useGrayscaleColorsMenuItem.setEnabled(false);
                this.useStandardColorsMenuItem.setEnabled(false);
                this.graphMenuItem.setEnabled(true);
                this.timelinesMenuItem.setEnabled(true);
                this.usageProfileMenuItem.setEnabled(true);
                this.communicationMenuItem.setEnabled(true);
                this.communicationVsTimeMenuItem.setEnabled(true);
                this.callTableMenuItem.setEnabled(true);
                this.viewLogFilesMenuItem.setEnabled(true);
                this.histogramsMenuItem.setEnabled(true);
                this.overviewMenuItem.setEnabled(true);
                this.animationMenuItem.setEnabled(true);
                this.timeProfileGraphMenuItem.setEnabled(true);
                this.userEventsMenuItem.setEnabled(true);
                this.outlierAnalysisMenuItem.setEnabled(true);
                this.multirunAnalysisMenuItem.setEnabled(true);
                this.functionToolMenuItem.setEnabled(true);
                this.AMPIUsageProfileMenuItem.setEnabled(true);
                this.noiseMinerMenuItem.setEnabled(true);
            }
        }
    }

    private void createMenus() {
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileOpenMenuItem = new JMenuItem("Open File(s)");
        this.fileCloseMenuItem = new JMenuItem("Close current data");
        this.fileCloseAllMenuItem = new JMenuItem("Close all data");
        this.fileQuitMenuItem = new JMenuItem("Quit");
        this.fileMenu.addActionListener(this);
        this.fileOpenMenuItem.addActionListener(this);
        this.fileCloseMenuItem.addActionListener(this);
        this.fileCloseAllMenuItem.addActionListener(this);
        this.fileQuitMenuItem.addActionListener(this);
        this.fileMenu.add(this.fileMenu);
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileMenu.add(this.fileCloseMenuItem);
        this.fileMenu.add(this.fileCloseAllMenuItem);
        this.fileMenu.add(this.fileQuitMenuItem);
        this.menubar.add(this.fileMenu);
        this.preferencesMenu = new JMenu("Preferences");
        this.changeBGColorMenuItem = new JMenuItem("Change Background Color");
        this.changeFGColorMenuItem = new JMenuItem("Change Foreground Color");
        this.useGrayscaleColorsMenuItem = new JMenuItem("Use Default Grayscale Colors");
        this.useStandardColorsMenuItem = new JMenuItem("Use Standard Colors");
        this.changeBGColorMenuItem.addActionListener(this);
        this.changeFGColorMenuItem.addActionListener(this);
        this.useGrayscaleColorsMenuItem.addActionListener(this);
        this.useStandardColorsMenuItem.addActionListener(this);
        this.preferencesMenu.add(this.changeBGColorMenuItem);
        this.preferencesMenu.add(this.changeFGColorMenuItem);
        this.preferencesMenu.add(this.useGrayscaleColorsMenuItem);
        this.preferencesMenu.add(this.useStandardColorsMenuItem);
        this.menubar.add(this.preferencesMenu);
        this.toolMenu = new JMenu("Tools");
        this.graphMenuItem = new JMenuItem("Graphs");
        this.timelinesMenuItem = new JMenuItem("Timelines");
        this.usageProfileMenuItem = new JMenuItem("Usage Profile");
        this.communicationMenuItem = new JMenuItem("Communication");
        this.communicationVsTimeMenuItem = new JMenuItem("Communication vs Time");
        this.callTableMenuItem = new JMenuItem("Call Table");
        this.viewLogFilesMenuItem = new JMenuItem("View Log Files");
        this.histogramsMenuItem = new JMenuItem("Histograms");
        this.overviewMenuItem = new JMenuItem("Overview");
        this.animationMenuItem = new JMenuItem("Animation");
        this.timeProfileGraphMenuItem = new JMenuItem("Time Profile Graph");
        this.userEventsMenuItem = new JMenuItem("User Events");
        this.outlierAnalysisMenuItem = new JMenuItem("Outlier Analysis");
        this.multirunAnalysisMenuItem = new JMenuItem("Multirun Analysis");
        this.functionToolMenuItem = new JMenuItem("Function Tool");
        this.AMPIUsageProfileMenuItem = new JMenuItem("AMPI Usage Profile");
        this.noiseMinerMenuItem = new JMenuItem("Noise Miner");
        this.graphMenuItem.addActionListener(this);
        this.timelinesMenuItem.addActionListener(this);
        this.usageProfileMenuItem.addActionListener(this);
        this.communicationMenuItem.addActionListener(this);
        this.communicationVsTimeMenuItem.addActionListener(this);
        this.callTableMenuItem.addActionListener(this);
        this.viewLogFilesMenuItem.addActionListener(this);
        this.histogramsMenuItem.addActionListener(this);
        this.overviewMenuItem.addActionListener(this);
        this.animationMenuItem.addActionListener(this);
        this.timeProfileGraphMenuItem.addActionListener(this);
        this.userEventsMenuItem.addActionListener(this);
        this.outlierAnalysisMenuItem.addActionListener(this);
        this.multirunAnalysisMenuItem.addActionListener(this);
        this.functionToolMenuItem.addActionListener(this);
        this.AMPIUsageProfileMenuItem.addActionListener(this);
        this.noiseMinerMenuItem.addActionListener(this);
        this.toolMenu.add(this.graphMenuItem);
        this.toolMenu.add(this.timelinesMenuItem);
        this.toolMenu.add(this.usageProfileMenuItem);
        this.toolMenu.add(this.communicationMenuItem);
        this.toolMenu.add(this.communicationVsTimeMenuItem);
        this.toolMenu.add(this.callTableMenuItem);
        this.toolMenu.add(this.viewLogFilesMenuItem);
        this.toolMenu.add(this.histogramsMenuItem);
        this.toolMenu.add(this.overviewMenuItem);
        this.toolMenu.add(this.animationMenuItem);
        this.toolMenu.add(this.timeProfileGraphMenuItem);
        this.toolMenu.add(this.userEventsMenuItem);
        this.toolMenu.add(this.outlierAnalysisMenuItem);
        this.toolMenu.add(this.multirunAnalysisMenuItem);
        this.toolMenu.add(this.functionToolMenuItem);
        this.toolMenu.add(this.AMPIUsageProfileMenuItem);
        this.toolMenu.add(this.noiseMinerMenuItem);
        this.menubar.add(this.toolMenu);
        this.parent.setJMenuBar(this.menubar);
        this.stateChanged(0);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)e.getSource();
            String arg = mi.getText();
            if (mi == this.fileOpenMenuItem) {
                this.parent.showOpenFileDialog();
            } else if (mi == this.fileCloseMenuItem) {
                this.parent.closeCurrent();
            } else if (mi == this.fileCloseAllMenuItem) {
                this.parent.closeAll();
            } else if (mi == this.fileQuitMenuItem) {
                ProjMain.shutdown(0);
            } else if (mi == this.changeBGColorMenuItem) {
                this.parent.changeBackground();
            } else if (mi == this.changeFGColorMenuItem) {
                this.parent.changeForeground();
            } else if (mi == this.useGrayscaleColorsMenuItem) {
                this.parent.setGrayscale();
            } else if (mi == this.useStandardColorsMenuItem) {
                this.parent.setFullColor();
            } else if (mi == this.graphMenuItem) {
                this.parent.openTool(new GraphWindow(this.parent));
            } else if (mi == this.timelinesMenuItem) {
                this.parent.openTool(new TimelineWindow(this.parent));
            } else if (mi == this.usageProfileMenuItem) {
                this.parent.openTool(new ProfileWindow(this.parent));
            } else if (mi == this.communicationMenuItem) {
                this.parent.openTool(new CommWindow(this.parent));
            } else if (mi == this.communicationVsTimeMenuItem) {
                this.parent.openTool(new CommTimeWindow(this.parent));
            } else if (mi == this.callTableMenuItem) {
                this.parent.openTool(new CallTableWindow(this.parent));
            } else if (mi == this.viewLogFilesMenuItem) {
                this.parent.openTool(new LogFileViewerWindow(this.parent));
            } else if (mi == this.histogramsMenuItem) {
                this.parent.openTool(new HistogramWindow(this.parent));
            } else if (mi == this.overviewMenuItem) {
                this.parent.openTool(new StlWindow(this.parent));
            } else if (mi == this.animationMenuItem) {
                this.parent.openTool(new AnimationWindow(this.parent));
            } else if (mi == this.timeProfileGraphMenuItem) {
                this.parent.openTool(new TimeProfileWindow(this.parent));
            } else if (mi == this.userEventsMenuItem) {
                this.parent.openTool(new UserEventsWindow(this.parent));
            } else if (mi == this.outlierAnalysisMenuItem) {
                this.parent.openTool(new OutlierAnalysisWindow(this.parent));
            } else if (mi == this.multirunAnalysisMenuItem) {
                this.parent.openTool(new MultiRunWindow(this.parent));
            } else if (mi == this.functionToolMenuItem) {
                this.parent.openTool(new FunctionTool(this.parent));
            } else if (mi == this.AMPIUsageProfileMenuItem) {
                this.parent.openTool(new AmpiProfileWindow(this.parent));
            } else if (mi == this.noiseMinerMenuItem) {
                this.parent.openTool(new NoiseMinerWindow(this.parent));
            } else {
                System.out.println("ERROR: unknown menu item was selected" + mi);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void fileOpened() {
        this.stateChanged(1);
    }

    public void lastFileClosed() {
        this.stateChanged(0);
    }

    public void summaryOnly() {
        this.stateChanged(2);
    }
}

