/*
 * Decompiled with CFR 0.152.
 */
package jade;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.collections.AST;
import antlr.debug.misc.ASTFrame;
import jade.JJ.J;
import jade.JavaLexer;
import jade.JavaRecognizer;
import jade.JavaTreeParser;
import jade.JavaTreeParser1;
import jade.JavaTreeParser2;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;

class Main {
    static boolean showTree = false;

    Main() {
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                System.err.println("Parsing...");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-showtree")) {
                        showTree = true;
                        continue;
                    }
                    Main.doFile(new File(stringArray[i]));
                }
            } else {
                System.err.println("Usage: java Main [-showtree] <directory or file name>");
            }
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public static void doFile(File file) throws Exception {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Main.doFile(new File(file, stringArray[i]));
            }
        } else if (file.getName().length() > 5 && file.getName().substring(file.getName().length() - 5).equals(".java")) {
            System.err.println("   " + file.getAbsolutePath());
            Main.parseFile(file.getName(), new BufferedReader(new FileReader(file)));
        }
    }

    public static void parseFile(String string, Reader reader) throws Exception {
        try {
            JavaLexer javaLexer = new JavaLexer(reader);
            javaLexer.setFilename(string);
            JavaRecognizer javaRecognizer = new JavaRecognizer(javaLexer);
            javaRecognizer.setFilename(string);
            javaRecognizer.setASTNodeClass("jade.JJ.ASTJ");
            javaRecognizer.compilationUnit();
            System.out.println("Pass 0 done");
            Main.doTreeAction(string, javaRecognizer.getAST(), javaRecognizer.getTokenNames());
        }
        catch (Exception exception) {
            System.err.println("parser exception: " + exception);
            exception.printStackTrace();
        }
    }

    public static void spaces(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
    }

    public static void DFS(AST aST, int n) {
        if (aST == null) {
            Main.spaces(n);
            System.out.println(aST);
            return;
        }
        Main.spaces(n);
        System.out.println(aST);
        Main.DFS(aST.getFirstChild(), n + 1);
        Main.DFS(aST.getNextSibling(), n);
    }

    public static void showTree(AST aST, String[] stringArray) {
        CommonAST cfr_ignored_0 = (CommonAST)aST;
        CommonAST.setVerboseStringConversion((boolean)true, (String[])stringArray);
        ASTFactory aSTFactory = new ASTFactory();
        AST aST2 = aSTFactory.create(0, "AST ROOT");
        aST2.setFirstChild(aST);
        final ASTFrame aSTFrame = new ASTFrame("Java AST", aST2);
        aSTFrame.setVisible(true);
        aSTFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                aSTFrame.setVisible(false);
                aSTFrame.dispose();
                System.exit(0);
            }
        });
    }

    public static void doTreeAction(String string, AST aST, String[] stringArray) {
        if (aST == null) {
            return;
        }
        if (showTree) {
            Main.showTree(aST, stringArray);
        }
        JavaTreeParser1 javaTreeParser1 = new JavaTreeParser1();
        try {
            javaTreeParser1.compilationUnit(aST);
            System.out.println("Pass 1 done");
        }
        catch (RecognitionException recognitionException) {
            System.err.println(recognitionException.getMessage());
            recognitionException.printStackTrace();
        }
        J.assert1(javaTreeParser1.getAST() == null);
        JavaTreeParser2 javaTreeParser2 = new JavaTreeParser2();
        try {
            javaTreeParser2.setASTNodeClass("jade.JJ.ASTJ");
            javaTreeParser2.compilationUnit(aST);
            System.out.println("Pass 2 done");
        }
        catch (RecognitionException recognitionException) {
            System.err.println(recognitionException.getMessage());
            recognitionException.printStackTrace();
        }
        AST aST2 = javaTreeParser2.getAST();
        if (showTree) {
            Main.showTree(aST2, javaTreeParser2.getTokenNames());
        }
        JavaTreeParser javaTreeParser = new JavaTreeParser();
        try {
            javaTreeParser.compilationUnit(aST2);
            System.out.println("Pass 3 done");
        }
        catch (RecognitionException recognitionException) {
            System.err.println(recognitionException.getMessage());
            recognitionException.printStackTrace();
        }
    }
}

