/* DEFS: message FP;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_FP::operator new(size_t s){
  return FP::alloc(__idx, s, 0, 0);
}
void *CMessage_FP::operator new(size_t s, int* sz){
  return FP::alloc(__idx, s, sz, 0);
}
void *CMessage_FP::operator new(size_t s, int* sz,const int pb){
  return FP::alloc(__idx, s, sz, pb);
}
void *CMessage_FP::operator new(size_t s, const int p) {
  return FP::alloc(__idx, s, 0, p);
}
void* CMessage_FP::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[1];
  offsets[0] = ALIGN8(sz);
  FP *newmsg = (FP *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void CMessage_FP::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_FP::pack(FP *msg) {
  return (void *) msg;
}
FP* CMessage_FP::unpack(void* buf) {
  FP *msg = (FP *) buf;
  return msg;
}
int CMessage_FP::__idx=0;
#endif

/* DEFS: group barrier: IrrGroup{
barrier(void);
void notify(void);
void callFP(void);
void reset(void);
void atBarrier(FP* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_barrier::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: barrier(void);
 */

/* DEFS: void notify(void);
 */
void CProxyElement_barrier::notify(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_notify_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_barrier::__idx_notify_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_barrier::__idx_notify_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void callFP(void);
 */
void CProxyElement_barrier::callFP(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_callFP_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_barrier::__idx_callFP_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_barrier::__idx_callFP_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void reset(void);
 */
void CProxyElement_barrier::reset(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_reset_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_barrier::__idx_reset_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_barrier::__idx_reset_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void atBarrier(FP* impl_msg);
 */
void CProxyElement_barrier::atBarrier(FP* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_atBarrier_FP, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_barrier::__idx_atBarrier_FP, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_barrier::__idx_atBarrier_FP, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}
/* DEFS: barrier(void);
 */
CkGroupID CProxy_barrier::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_barrier::__idx, CkIndex_barrier::__idx_barrier_void, impl_msg);
}
 int CkIndex_barrier::__idx_barrier_void=0;
void CkIndex_barrier::_call_barrier_void(void* impl_msg,barrier * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) barrier();
}

/* DEFS: void notify(void);
 */
void CProxy_barrier::notify(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_notify_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_barrier::__idx_notify_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_barrier::__idx_notify_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_barrier::notify(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_barrier::__idx_notify_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_barrier::__idx_notify_void=0;
void CkIndex_barrier::_call_notify_void(void* impl_msg,barrier * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->notify();
}

/* DEFS: void callFP(void);
 */
void CProxy_barrier::callFP(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_callFP_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_barrier::__idx_callFP_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_barrier::__idx_callFP_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_barrier::callFP(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_barrier::__idx_callFP_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_barrier::__idx_callFP_void=0;
void CkIndex_barrier::_call_callFP_void(void* impl_msg,barrier * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->callFP();
}

/* DEFS: void reset(void);
 */
void CProxy_barrier::reset(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_reset_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_barrier::__idx_reset_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_barrier::__idx_reset_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_barrier::reset(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_barrier::__idx_reset_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_barrier::__idx_reset_void=0;
void CkIndex_barrier::_call_reset_void(void* impl_msg,barrier * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->reset();
}

/* DEFS: void atBarrier(FP* impl_msg);
 */
void CProxy_barrier::atBarrier(FP* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_barrier::__idx_atBarrier_FP, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_barrier::__idx_atBarrier_FP, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_barrier::__idx_atBarrier_FP, impl_msg, ckGetGroupID(),0);
}
    void CProxy_barrier::atBarrier(FP* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_barrier::__idx_atBarrier_FP, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_barrier::__idx_atBarrier_FP=0;
void CkIndex_barrier::_call_atBarrier_FP(void* impl_msg,barrier * impl_obj)
{
  impl_obj->atBarrier((FP*)impl_msg);
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_barrier::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,barrier::isIrreducible());
// REG: barrier(void);
  __idx_barrier_void = CkRegisterEp("barrier(void)",
     (CkCallFnPtr)_call_barrier_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_barrier_void);

// REG: void notify(void);
  __idx_notify_void = CkRegisterEp("notify(void)",
     (CkCallFnPtr)_call_notify_void, 0, __idx, 0);

// REG: void callFP(void);
  __idx_callFP_void = CkRegisterEp("callFP(void)",
     (CkCallFnPtr)_call_callFP_void, 0, __idx, 0);

// REG: void reset(void);
  __idx_reset_void = CkRegisterEp("reset(void)",
     (CkCallFnPtr)_call_reset_void, 0, __idx, 0);

// REG: void atBarrier(FP* impl_msg);
  __idx_atBarrier_FP = CkRegisterEp("atBarrier(FP* impl_msg)",
     (CkCallFnPtr)_call_atBarrier_FP, CMessage_FP::__idx, __idx, 0);
}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerbarrier(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message FP;
*/
CMessage_FP::__register("FP", sizeof(FP),(CkPackFnPtr) FP::pack,(CkUnpackFnPtr) FP::unpack);

/* REG: group barrier: IrrGroup{
barrier(void);
void notify(void);
void callFP(void);
void reset(void);
void atBarrier(FP* impl_msg);
};
*/
  CkIndex_barrier::__register("barrier", sizeof(barrier));

}
#endif
