/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import projections.gui.Analysis;
import projections.gui.JIntTextField;
import projections.gui.MainWindow;
import projections.gui.OutlierAnalysisWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class OutlierDialog
extends RangeDialog {
    int myRun = 0;
    protected JPanel outlierPanel;
    protected JComboBox attributeList;
    protected JComboBox activityList;
    protected JIntTextField thresholdField;
    protected JIntTextField kField;
    private JTextArea errorText;
    protected int currentAttribute = 0;
    protected int currentActivity = 0;
    protected int threshold = MainWindow.runObject[this.myRun].getNumProcessors() <= 256 ? (int)Math.ceil(0.1 * (double)MainWindow.runObject[this.myRun].getNumProcessors()) : 20;
    protected int k = 5;
    private int lastAttribute = -1;
    private int lastActivity = -1;

    public OutlierDialog(OutlierAnalysisWindow mainWindow, String titleString) {
        super(mainWindow, titleString);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b == this.bOK) {
                if (this.activityList.getSelectedIndex() >= 0 && this.attributeList.getSelectedIndex() >= 0) {
                    if (this.activityList.getSelectedIndex() == 2 || this.activityList.getSelectedIndex() == 1 && this.attributeList.getSelectedIndex() >= 1) {
                        this.errorText.setText("ERROR: Attribute " + ((OutlierAnalysisWindow)this.parentWindow).attributes[0][this.attributeList.getSelectedIndex()] + " is incompatible with Activity " + Analysis.NAMES[this.activityList.getSelectedIndex()]);
                        return;
                    }
                } else {
                    this.errorText.setText("ERROR: no valid Attribute or Activity selection!");
                    return;
                }
                JTextField someField = this.checkConsistent();
                if (someField != null) {
                    someField.selectAll();
                    someField.requestFocus();
                    return;
                }
            } else if (b == this.bUpdate) {
                this.updateData(this.thresholdField);
                this.updateData(this.kField);
            }
        } else if (evt.getSource() instanceof JComboBox) {
            JComboBox item = (JComboBox)evt.getSource();
            if (item == this.attributeList) {
                this.currentAttribute = item.getSelectedIndex();
            } else if (item == this.activityList) {
                this.currentActivity = item.getSelectedIndex();
            }
        }
        super.actionPerformed(evt);
    }

    JPanel createMainLayout() {
        JPanel inputPanel = new JPanel();
        JPanel baseMainPanel = super.createMainLayout();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.outlierPanel = new JPanel();
        this.outlierPanel.setLayout(gbl);
        this.attributeList = new JComboBox<String>(((OutlierAnalysisWindow)this.parentWindow).attributes[0]);
        this.attributeList.setSelectedIndex(this.currentAttribute);
        JLabel attributeLabel = new JLabel("Attribute: ", 4);
        this.attributeList.addActionListener(this);
        this.activityList = new JComboBox<String>(Analysis.NAMES);
        this.activityList.setSelectedIndex(this.currentActivity);
        JLabel activityLabel = new JLabel("Activity: ", 4);
        this.activityList.addActionListener(this);
        JLabel thresholdLabel = new JLabel("Outlier Threshold: ", 4);
        this.thresholdField = new JIntTextField(this.threshold, 8);
        JLabel thresholdPost = new JLabel("Processors", 2);
        this.thresholdField.addActionListener(this);
        JLabel kLabel = new JLabel("Number of Clusters: ", 4);
        this.kField = new JIntTextField(this.k, 3);
        this.kField.addActionListener(this);
        this.errorText = new JTextArea();
        this.errorText.setRows(3);
        this.errorText.setEnabled(false);
        this.errorText.setLineWrap(true);
        this.errorText.setForeground(Color.red);
        JScrollPane scrollText = new JScrollPane(this.errorText, 20, 31);
        Util.gblAdd(this.outlierPanel, attributeLabel, gbc, 0, 0, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.attributeList, gbc, 1, 0, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, activityLabel, gbc, 0, 1, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.activityList, gbc, 1, 1, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, thresholdLabel, gbc, 0, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.thresholdField, gbc, 1, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, thresholdPost, gbc, 2, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, kLabel, gbc, 0, 3, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.kField, gbc, 1, 3, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, scrollText, gbc, 0, 4, 3, 3, 0, 1);
        inputPanel.setLayout(gbl);
        Util.gblAdd(inputPanel, baseMainPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(inputPanel, this.outlierPanel, gbc, 0, 1, 1, 1, 1, 1);
        return inputPanel;
    }

    void updateData(JTextField field) {
        if (field instanceof JIntTextField && field == this.thresholdField) {
            this.threshold = this.thresholdField.getValue();
        }
        super.updateData(field);
    }

    JTextField checkConsistent() {
        if (this.thresholdField.getValue() < 0 || this.thresholdField.getValue() > this.processorsField.getValue(MainWindow.runObject[this.myRun].getNumProcessors()).size()) {
            return this.thresholdField;
        }
        return super.checkConsistent();
    }

    public boolean isModified() {
        return this.threshold != this.thresholdField.getValue() || this.currentActivity != this.lastActivity || this.currentAttribute != this.lastAttribute || super.isModified();
    }

    void setParameters() {
        this.lastActivity = this.activityList.getSelectedIndex();
        this.lastAttribute = this.attributeList.getSelectedIndex();
        super.setParameters();
    }

    void updateFields() {
        super.updateFields();
    }

    void updateDerived() {
    }
}

